/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.messaging.types.MouseChangeMessage;
import technology.rocketjump.undermount.rendering.RenderingOptions;
import technology.rocketjump.undermount.rendering.camera.DisplaySettings;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.screens.GameScreen;

@Singleton
public class GameWorldInputHandler
implements InputProcessor,
GameContextAware {
    public static final int SCROLL_BORDER = 2;
    private final PrimaryCameraWrapper primaryCameraWrapper;
    private final RenderingOptions renderingOptions;
    private final MessageDispatcher messageDispatcher;
    private GameContext gameContext;

    @Inject
    public GameWorldInputHandler(PrimaryCameraWrapper primaryCameraWrapper, RenderingOptions renderingOptions, MessageDispatcher messageDispatcher) {
        this.primaryCameraWrapper = primaryCameraWrapper;
        this.renderingOptions = renderingOptions;
        this.messageDispatcher = messageDispatcher;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 29) {
            this.primaryCameraWrapper.setMovementX(-1.0f);
        } else if (keycode == 32) {
            this.primaryCameraWrapper.setMovementX(1.0f);
        } else if (keycode == 51) {
            this.primaryCameraWrapper.setMovementY(1.0f);
        } else if (keycode == 47) {
            this.primaryCameraWrapper.setMovementY(-1.0f);
        } else if (keycode == 21) {
            this.primaryCameraWrapper.setMovementX(-1.0f);
        } else if (keycode == 22) {
            this.primaryCameraWrapper.setMovementX(1.0f);
        } else if (keycode == 19) {
            this.primaryCameraWrapper.setMovementY(1.0f);
        } else if (keycode == 20) {
            this.primaryCameraWrapper.setMovementY(-1.0f);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (keycode == 8 && this.gameContext != null) {
            this.gameContext.getGameClock().setSpeedMultiplier(1.0f);
        } else if (keycode == 9 && this.gameContext != null) {
            this.gameContext.getGameClock().setSpeedMultiplier(2.0f);
        } else if (keycode == 10 && this.gameContext != null) {
            this.gameContext.getGameClock().setSpeedMultiplier(5.0f);
        } else if (keycode == 11 && this.gameContext != null) {
            this.gameContext.getGameClock().setSpeedMultiplier(10.0f);
        } else if (keycode == 29 || keycode == 21) {
            this.primaryCameraWrapper.setMovementX(0.0f);
        } else if (keycode == 32 || keycode == 22) {
            this.primaryCameraWrapper.setMovementX(0.0f);
        } else if (keycode == 51 || keycode == 19) {
            this.primaryCameraWrapper.setMovementY(0.0f);
        } else if (keycode == 47 || keycode == 20) {
            this.primaryCameraWrapper.setMovementY(0.0f);
        } else if (keycode == 43 || keycode == 44 || keycode == 39 || keycode == 40) {
            this.primaryCameraWrapper.setMovementZ(0.0f);
        } else if (keycode == 33 || keycode == 46) {
            this.messageDispatcher.dispatchMessage(803);
        } else if (keycode == 254) {
            GameWorldInputHandler.toggleFullscreen();
        } else if (keycode == 131) {
            this.messageDispatcher.dispatchMessage(2, (Object)GameScreen.MAIN_MENU);
        } else {
            return false;
        }
        return true;
    }

    public static void toggleFullscreen() {
        if (DisplaySettings.isGamefullscreen && Gdx.graphics.supportsDisplayModeChange()) {
            Gdx.graphics.setWindowedMode(DisplaySettings.windowedWidth, DisplaySettings.windowedHeight);
            DisplaySettings.isGamefullscreen = false;
        } else if (Gdx.graphics.supportsDisplayModeChange()) {
            Gdx.graphics.setWindowedMode(DisplaySettings.desktopWidth, DisplaySettings.desktopHeight);
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
            DisplaySettings.isGamefullscreen = true;
        }
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.renderingOptions.debug().showIndividualLightingBuffers()) {
            screenX = this.renderingOptions.debug().adjustScreenXForSplitView(screenX);
            screenY = this.renderingOptions.debug().adjustScreenYForSplitView(screenY);
        }
        Vector3 worldPosition = this.primaryCameraWrapper.getCamera().unproject(new Vector3(screenX, screenY, 0.0f));
        Vector2 worldPosition2 = new Vector2(worldPosition.x, worldPosition.y);
        MouseChangeMessage.MouseButtonType mouseButtonType = MouseChangeMessage.MouseButtonType.byButtonCode(button);
        if (mouseButtonType != null) {
            MouseChangeMessage mouseChangeMessage = new MouseChangeMessage(screenX, screenY, worldPosition2, mouseButtonType);
            this.messageDispatcher.dispatchMessage(null, 200, (Object)mouseChangeMessage);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.renderingOptions.debug().showIndividualLightingBuffers()) {
            screenX = this.renderingOptions.debug().adjustScreenXForSplitView(screenX);
            screenY = this.renderingOptions.debug().adjustScreenYForSplitView(screenY);
        }
        Vector3 worldPosition = this.primaryCameraWrapper.getCamera().unproject(new Vector3(screenX, screenY, 0.0f));
        Vector2 worldPosition2 = new Vector2(worldPosition.x, worldPosition.y);
        MouseChangeMessage.MouseButtonType mouseButtonType = MouseChangeMessage.MouseButtonType.byButtonCode(button);
        if (mouseButtonType != null) {
            MouseChangeMessage mouseChangeMessage = new MouseChangeMessage(screenX, screenY, worldPosition2, mouseButtonType);
            this.messageDispatcher.dispatchMessage(null, 201, (Object)mouseChangeMessage);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        Vector3 worldPosition = this.primaryCameraWrapper.getCamera().unproject(new Vector3(screenX, screenY, 0.0f));
        Vector2 worldPosition2 = new Vector2(worldPosition.x, worldPosition.y);
        MouseChangeMessage mouseMovedMessage = new MouseChangeMessage(screenX, screenY, worldPosition2, null);
        this.messageDispatcher.dispatchMessage(null, 202, (Object)mouseMovedMessage);
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        if (Gdx.input.isKeyPressed(29) || Gdx.input.isKeyPressed(21) || Gdx.input.isKeyPressed(32) || Gdx.input.isKeyPressed(22) || Gdx.input.isKeyPressed(51) || Gdx.input.isKeyPressed(19) || Gdx.input.isKeyPressed(47) || Gdx.input.isKeyPressed(20)) {
            return false;
        }
        if (DisplaySettings.isGamefullscreen) {
            if (screenX <= 2) {
                this.primaryCameraWrapper.setMovementX(-1.0f);
            } else if (screenX >= width - 2) {
                this.primaryCameraWrapper.setMovementX(1.0f);
            } else {
                this.primaryCameraWrapper.setMovementX(0.0f);
            }
            if (screenY <= 2) {
                this.primaryCameraWrapper.setMovementY(1.0f);
            } else if (screenY >= height - 2) {
                this.primaryCameraWrapper.setMovementY(-1.0f);
            } else {
                this.primaryCameraWrapper.setMovementY(0.0f);
            }
        }
        return true;
    }

    @Override
    public boolean scrolled(int amount) {
        this.primaryCameraWrapper.zoom(amount);
        return true;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

